/*-
 * Copyright (c) 1998 Robert N. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name Robert N. Watson may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: testsyscall.c,v 1.4 1998/06/26 13:17:36 robert Exp $
 */
#include <sys/types.h>
#include <sys/time.h>
#include <machine/types.h>
#include <unistd.h>

#include <stdio.h>
#include <string.h>

#include "../common/ktoken_const.h"
#include "../common/ktoken_types.h"
#include "../common/ktoken_structs.h"
#include "libktoken.h"

int main()
{
/*************
 * Test Code *
 *************/

	pagid_t pagid;
	char *id, buf[120];
	struct utokenstr token1, token2;
	tokenid_t tokenid;
	int i;

	pagid = t_newpag();
	if (!pagid) {
		perror("testsyscall.t_newpag()");
	}
	printf("After newpag, Pagid: %lu\n", pagid);

	pagid = t_getpag();
	if (!pagid) {
		perror("testsyscall.t_getpag()");
	}
	printf("After getpag, Pagid: %lu\n", pagid);

	if (fork()) {
		id = "parent";
	} else {
		id = "child";
	}

	printf("%s is alive\n", id);
	pagid = t_getpag();
	if (!pagid) {
		sprintf(buf, "%s: testsyscall.t_getpag()", id);
		perror(buf);
	}
	printf("%s: After getpag, Pagid: %lu\n", id, pagid);

	if (!strcmp("child", id)) {
		/* child */
		printf("%s: Child is dying\n", id);
		exit(0);
	}

	sleep(10);
	printf("%s: preparing to generate a token\n", id);
	token1.major = 1;
	token1.minor = 2;
	token1.minorminor = 3;
	tokenid = t_createtoken(&token1);
	printf("%s: received tokenid %lu\n", id, tokenid);
	printf("%s: preparing to read back token\n", id);
	i = t_readtoken(tokenid, &token2);
	if (i) {
		perror("testsyscall.t_readtoken()");
	} else {
		printf("%s: received token %lu with types (%d,%d,%d)\n",
			id, token2.tokenid, token2.major, token2.minor,
			token2.minorminor);
	}
	printf("%s: going to read a non-existent token\n", id);
	i = t_readtoken(tokenid+20, &token2);
	if (i) {
		perror("testsyscall.t_readtoken()");
	} else {
		printf("%s: received token %lu with types (%d,%d,%d)\n",
			id, token2.tokenid, token2.major, token2.minor,
			token2.minorminor);
	}

/*****************
 * End Test Code *
 *****************/
	return(0);
}
