/*-
 * Copyright (c) 1998 Robert N. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name Robert N. Watson may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: ktoken.h,v 1.6 1998/07/02 22:15:24 robert Exp $
 */
#ifndef _KTOKEN_H
#define _KTOKEN_H

extern int ktdebug;

static int ktoken_newpag(struct proc *p, struct t_syscall_args *uap);
static int ktoken_getpag(struct proc *p, struct t_syscall_args *uap);
static int ktoken_readtoken(struct proc *p, struct t_syscall_args *uap);
static int ktoken_modifytoken(struct proc *p, struct t_syscall_args *uap);
static int ktoken_createtoken(struct proc *p, struct t_syscall_args *uap);
static int ktoken_reflecttoken(struct proc *p, struct t_syscall_args *uap);
static int ktoken_deletetoken(struct proc *p, struct t_syscall_args *uap);
static int ktoken_findtoken(struct proc *p, struct t_syscall_args *uap);
static int ktoken_setdebug(struct proc *p, struct t_syscall_args *uap);
static int ktoken_settokend(struct proc *p, struct t_syscall_args *uap);
static int ktoken_setuidtoken(struct proc *p, struct t_syscall_args *uap);
void ktoken_at_fork(struct proc *parent, struct proc *child, int flags);
void ktoken_at_exit(struct proc *procp);


#endif
