/*-
 * Copyright (c) 1998 Robert N. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name Robert N. Watson may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: deletetoken.c,v 1.2 1998/06/26 13:17:36 robert Exp $
 */
#include <sys/types.h>
#include <sys/time.h>
#include <machine/types.h>
#include <unistd.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "../common/ktoken_const.h"
#include "../common/ktoken_types.h"
#include "../common/ktoken_structs.h"
#include "libktoken.h"

int main(int argc, char *argv[])
{
/*************
 * Test Code *
 *************/

    struct utokenstr u;
	tokenid_t tokenid, current;
	int i;

	if (argc != 2) {
		printf("deletetoken [tokenid|-a]\n");
		exit(-1);
	}

	if (strcmp(argv[1], "-a")) {
	    tokenid = atoi(argv[1]);
	    printf("Deleting tokenid %lu\n", tokenid);
	    i = t_deletetoken(tokenid);
	    if (i) {
		perror("deletetoken");
		exit(-1);
	    }
	    printf("Delete succeeded\n");
	} else {
	    /* -a */
	    printf("Deleting tokenids: ");
	    current = 0;
	    while ((current = t_findtoken(current, 0, &u))) {
		printf(" %lu", current);
		t_deletetoken(current);
		current++;
	    }
	    printf("\n");
	    printf("deletetoken: done\n");
	}
		

/*****************
 * End Test Code *
 *****************/
	return(0);
}
