/*-
 * Copyright (c) 1998 Robert N. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name Robert N. Watson may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: ktoken_const.h,v 1.4 1998/07/06 00:18:41 robert Exp $
 */
#ifndef _KTOKEN_CONST_H
#define _KTOKEN_CONST_H

/*
 * structures and constants relating to tokens
 */

/* 
 * rights flags
 */

#define T_R_READ             0x0001 /* contents readable by user process */
#define T_R_MODIFY           0x0002 /* rights/contents writable by
                                       user process */
#define T_R_DELETE           0x0004 /* token deletable by user process */
#define T_R_INHERIT          0x0008 /* token inherited across newpag() */
#define T_R_EXPIRE           0x0010 /* token will expire automatically */
#define T_R_TRANSFERABLE     0x0020 /* token may be given away */
#define T_R_TRANSFERABLEONCE 0x0040 /* token may be given away ONCE */

/*
 * data structure limits
 */

#define T_MAX_NAMELEN    80
#define T_MAX_REALMLEN   80
#define T_MAX_DATALEN    512
#define T_MAX_SYSTOKENS  4096
#define T_MAX_PAGTOKENS  128

/*
 * return codes 
 */

#define TOK_SUCCESS      0
#define TOK_RESLIMIT     -1

/*
 * token structure limits
 */

/* This might want to be changed, but good for a first impl. */
#define T_STRINGLEN_MAX	128
#define T_DATALEN_MAX	256

/*
 * useful non-return returns
 */

#define BADTOKENID 0
#define BADPAGID 0

/* 
 * field names for modification and searching
 */

#define TOKEN_FIELD_TOKENID     1
#define TOKEN_FIELD_NAME        2
#define TOKEN_FIELD_INSTANCE    4
#define TOKEN_FIELD_REALM       8
#define TOKEN_FIELD_RIGHTS      16
#define TOKEN_FIELD_MAJOR       32
#define TOKEN_FIELD_MINOR       64
#define TOKEN_FIELD_MINORMINOR  128
#define TOKEN_FIELD_PUBLICDAT   256
#define TOKEN_FIELD_PRIVATEDAT  512
#define TOKEN_FIELD_EXPIRETIME  1024
#define TOKEN_FIELD_CREATETIME  2048
#define TOKEN_FIELD_CREATOR     4096

#define TOKEN_FIELD_ALL (TOKEN_FIELD_TOKENID | TOKEN_FIELD_NAME | \
        TOKEN_FIELD_INSTANCE | TOKEN_FIELD_REALM | TOKEN_FIELD_RIGHTS | \
	TOKEN_FIELD_MAJOR | TOKEN_FIELD_MINOR | TOKEN_FIELD_MINORMINOR | \
	TOKEN_FIELD_PUBLICDAT | TOKEN_FIELD_PRIVATEDAT | \
        TOKEN_FIELD_EXPIRETIME | TOKEN_FIELD_CREATETIME | \
        TOKEN_FIELD_CREATOR)

/* 
 * major types
 */

#define TOKEN_MAJ_NULL       0
#define TOKEN_MAJ_LOCALPRIV  1          /* reserved for local use */
#define TOKEN_MAJ_KERBEROS4  2          /* kerberos IV ticket */
#define TOKEN_MAJ_KERBEROS5  3          /* kerberos V ticket */
#define TOKEN_MAJ_CODA       5          /* Coda token */
#define TOKEN_MAJ_RSA        6          /* RSA keypair */
#define TOKEN_MAJ_IPSEC      7          /* IPSec keying material XXXX */
#define TOKEN_MAJ_SSHAGENT   8          /* SSH Agent data */
#define TOKEN_MAJ_XAUTH      9          /* X magic cookies, etc */

/* 
 * creator types
 */

#define TOKEN_CRT_NULL       0
#define TOKEN_CRT_KERNEL     1          /* created by kernel */
#define TOKEN_CRT_PROCESS    2          /* created by user process */
#define TOKEN_CRT_TOKEND     3          /* created with a TOKEND auth token */

/*
 * LOCALPRIV minor types
 * - values trusted if creator of kernel, TOKEND
 */

/* local authentication tokens */
#define TOKEN_LPRIV_NULL     0
#define TOKEN_LPRIV_TOKEND   1          /* priveledged TOKEND auth token */
#define TOKEN_LPRIV_UID      2          /* minor type is a UNIX UID */
#define TOKEN_LPRIV_GID      3          /* minor type is a UNIX GID */
/* local authorization tokens */
#define TOKEN_LPRIV_UDPBIND  1001       /* may bind udp port in minor */
#define TOKEN_LPRIV_TCPBIND  1002       /* may bind tcp port in minor */
/* local sandbox authorization tokens */
#define TOKEN_LPRIV_MAYCONNECT  12001   /* may connect to IP in data field */


/*
 * Kerberos IV types 
 */

/* key version number for creds is kept in minorminor */
#define kvno minorminor
#define TOKEN_KRB4_NULL      0
#define TOKEN_KRB4_PRIMARY   1   /* store primary ticket file id */
#define TOKEN_KRB4_CRED      2   /* store a credentials block (ticket) */


/* 
 * utility functions
 */


#endif
