/*-
 * Copyright (c) 1998 Robert N. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name Robert N. Watson may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: interface.c,v 1.4 1998/07/13 22:35:15 robert Exp $
 */
#include <stdlib.h>
#include <dialog.h>
#include "types.h"
#include "const.h"
#include "globals.h"
#include "utils.h"
#include "interface.h"

struct setstr *curset;
struct declarestr *selecteddeclare;

int numsetmenuentries=0;
dialogMenuItem *setmenulist = 0;

void interface_init(void) {
	init_dialog();
	dialog_clear();
}

void interface_destroy(void) {
	end_dialog();
}

int interface_yesno(char *title, char *prompt) {
#ifdef CAUTIOUS
	if ((!title) || (!prompt)) 
		panic("interface_yesno(): null title or prompt\n");
	if ((strlen(title) > 1024) || (strlen(prompt) > 2048))
		panic("interface_yesno(): title or prompt way long\n");
#endif
	return !dialog_yesno(title, prompt, 10, 60);
}

void interface_notify(char *msg) {
#ifdef CAUTIOUS
	if (!msg)
		panic("interface_notify(): null msg\n");
#endif
	dialog_notify(msg);
}

int interface_catch_set_checked(dialogMenuItem *self) {
	struct setstr *set;
#ifdef CAUTIOUS
	if (!self)
		panic("interface_catch_set_checked(): null self\n");
	if (!self->data)
		panic("interface_catch_set_checked(): null self->data\n");
#endif
	set = (struct setstr *) self->data;
	if (set->chosen_level) {
		if (xalsoifdefault) {
			return(TRUE);
		}
		/* x only if non-0 and non-default */
		if (set->chosen_level != &default_declarestr)
			return(TRUE);
		/* so return FALSE */
	}
	return(FALSE);
}

int interface_catch_set_fire(dialogMenuItem *self) {
	struct setstr *set;
	set = (struct setstr *) self->data;

#ifdef CAUTIOUS
	if (!set) panic("interface_catch_set_fire(): null self->data\n");
#endif

	interface_modify_set(set);
	return(DITEM_REDRAW);
}

void interface_catch_set_selected(dialogMenuItem *self, int is_selected) {
#ifdef CAUTION
	if (!self) panic("interface_catch_set_selected(): null self\n");
#endif
}

/* handle the interface, return:
 * 0 - success (OK)
 * 1 - cancel
 * -1 - error
 */
int interface_selectset(void) {
	struct setstr *set;
	dialogMenuItem *di;
	int i, size;

	if (!setmenulist) {
		/* build only once */
		/* allow for "Implement", "Cancel" */
		numsetmenuentries = getnumsets() + 2;
		setmenulist = (dialogMenuItem *)
			malloc(sizeof(dialogMenuItem) *
			numsetmenuentries);
		di = &setmenulist[0];
		di->title = "Implement";
		di->prompt = "Write current policy to implementation file";
		di->checked = 0;
		di->fire = 0;
		di->selected = 0;
		di->data = 0;
		di = &setmenulist[1];
		di->title = "Cancel";
		di->prompt = "Abandon current policy and exit";
		di->checked = 0;
		di->fire = 0;
		di->selected = 0;
		di->data = 0;

		i = 2;
		for (set = topset; (set); set = set->next) {
			di = &setmenulist[i];
			di->prompt = set->name;
			if (set->comments) 
				di->title = set->comments->commentstring;
			else
				di->title = "";
			di->checked = interface_catch_set_checked;
			di->fire = interface_catch_set_fire;
			di->selected = interface_catch_set_selected;
			di->data = set;
			di->lbra = '[';
			di->mark = 'X';
			di->rbra = ']';
			i++;
		}
	}

	curset = 0;

	if (numsetmenuentries-2 > 16)
		size = 16;
	else
		size = numsetmenuentries-2;
	i = dialog_checklist("Select a set to modify",
			"Select a set to modify the policy for",
			23, 78, size, (-1) * (numsetmenuentries-2),
			&setmenulist[2], (char *) 0);

	return(i);
}

int interface_catch_declare_checked(dialogMenuItem *self) {
	struct declarestr *declare;

#ifdef CAUTIOUS
	if (!self) panic("interface_catch_declare_checked(): null self\n");
	if (!self->data) panic("interface_catch_declare_checked(): "
		"self->data null\n");
#endif

	declare = (struct declarestr *) self->data;
	if (selecteddeclare == declare) {
		return(TRUE);
	} else {
		return(FALSE);
	}
}

int interface_catch_declare_fire(dialogMenuItem *self) {
	struct declarestr *declare;
#ifdef CAUTIOUS
	if (!self) panic("interface_catch_declare_fire(): null self\n");
	if (!self->data) panic("interface_catch_declare_fire(): null "
		"self->data\n");
#endif
	declare = (struct declarestr *) self->data;
	selecteddeclare = declare;
	return(DITEM_REDRAW);
}

/* provide a tree-like interface to a particular set */
void interface_modify_set(struct setstr *set) {
	/* build a menu describing the current options, which is selected,
	 * etc */
	dialogMenuItem *di;
	int i, size;
	dialogMenuItem *declarelist;
	struct setbodystr *setbody;
	int nummenuentries;
#ifdef CAUTIOUS
	if (!set) panic("interface_modify_set(): null set\n");
#endif

	nummenuentries = getnumdeclares(set)+1; /* +Default */
	declarelist = (dialogMenuItem *) malloc(sizeof(dialogMenuItem) *
		nummenuentries);

	/* construct default menu item */
	di = &declarelist[0];
	di->prompt = default_declarestr.name;
	di->title = default_declarestr.commentstring;
	di->checked = interface_catch_declare_checked;
	di->fire = interface_catch_declare_fire;
	di->selected = 0;
	di->data = &default_declarestr;
	di->lbra = '[';
	di->mark = 'X';
	di->rbra = ']';

	i = 1;
	selecteddeclare = set->chosen_level;

	for (setbody = set->declares; (setbody); setbody = setbody->next) {
		di = &declarelist[i];
		di->prompt = setbody->declare->name;
		di->title = setbody->declare->commentstring;
		di->checked = interface_catch_declare_checked;
		di->fire = interface_catch_declare_fire;
		di->selected = 0;
		di->data = setbody->declare;
		di->lbra = '[';
		di->mark = 'X';
		di->rbra = ']';
		i++;
	}

        if (nummenuentries > 16)
                size = 16;
        else    
                size = nummenuentries;

	i = dialog_checklist(set->name, "Select a policy level for this set",
		23, 60, size, (-1 ) * nummenuentries, &declarelist[0], 0);

	if (i == 0) {
		/* user selected OK */
		set->chosen_level = selecteddeclare;
	}
/*
	dialog_menu(set->name, "Select a policy level for this set",
		23, 60, size, (-1 ) * nummenuentries, &declarelist[0],
		0, 0, 0);
*/

#ifndef CAUTIOUS
	free(declarelist);
#endif
}

