/*-
 * Copyright (c) 1998 Robert N. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name Robert N. Watson may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: checker.c,v 1.2 1998/07/13 22:35:15 robert Exp $
 */

#include <stdio.h>
#include "types.h"
#include "const.h"
#include "globals.h"
#include "utils.h"

#define CHECKWARN(line...) fprintf(stderr, ## line)

extern char *source;
extern int parse_debug;


/* loosely bucket sort the members of setbody into setstr */
int organize(struct setstr *set) {
	struct setbodystr *setbody, *temp;

	setbody = set->setbody;
	while (setbody) {
		temp = setbody->next;
		if (setbody->commentstring) {
			if (parse_debug)
				CHECKWARN("%s: set '%s' has comment '%s'\n",
					source, set->name, setbody->commentstring);
			setbody->next = set->comments;
			set->comments = setbody;
		} else
		if (setbody->filename) {
			if (parse_debug)
				CHECKWARN("%s: set '%s' has file '%s'\n",
					source, set->name, setbody->filename);
			setbody->next = set->files;
			set->files = setbody;
		} else
		if (setbody->declare) {
			if (parse_debug)
				CHECKWARN("%s: set '%s' has level '%s'\n",
					source, set->name, setbody->declare->name);
			setbody->next = set->declares;
			set->declares = setbody;
		} else {
			CHECKWARN("%s: set '%s' contains bad setbody\n",
                                source, set->name);
			return(0);
		}
		setbody = temp;
	}
	set->setbody = 0;
	return(1);
}

/* given a set pointer, verify that:
 *
 * 1. All levels used in the set are declared
 * 2. All levels declared are used
 * 3. Filenames do not appear more than once in a set  (XX)
 *
 * (XX) - not implemented
 */
int checkset(struct setstr *set) {
	struct setbodystr *setbody;
	struct filebodystr *filebody;

	/* bucket the setbody types */

	if (!organize(set)) {
		return(0);
	}

	/* verify each level used in a filebody to see if it is declared */
	for (setbody = set->files; (setbody); setbody = setbody->next) {
		for (filebody = setbody->filebody; (filebody);
			filebody = filebody->next) {
			if (filebody->type != FILE_COMMENT) {
				if (!getsetlevel(set, filebody->level)) {
					CHECKWARN("%s: set '%s' uses undeclared "
						"level '%s' for file '%s'\n",
						source, set->name,
						filebody->level,
						setbody->filename);
					return(0);
				}
			}
		}
	}
	return(1);
}


