/*-
 * Copyright (c) 1999 Robert N. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *       $Id: $
 */

#include <sys/types.h>
#include <sys/audit.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define PATH_1	"/etc/motd"

void main(void) {
	aud_rec_t	rec_in;
	aud_evinfo_t	evinfo_in;
	aud_hdr_t	hdr;
	aud_info_t	info_in;
	aud_status_t	status;
	int	i;

	rec_in = aud_init_record();

	if (!rec_in) {
		perror("aud_init_record");
		exit(-1);
	}

	fprintf(stdout, "aud_init_record: resulting record size %d\n",
	    aud_size(rec_in));

	i = aud_put_event(rec_in, NULL, &evinfo_in);
	if (i == -1) {
		perror("aud_put_event");
		exit(-1);
	}

	fprintf(stdout, "aud_put_event: resulting record size %d\n",
	    aud_size(rec_in));

	i = aud_put_hdr(rec_in, NULL, &hdr);
	if (i == -1) {
		perror("aud_put_hdr");
		exit(-1);
	}

	fprintf(stdout, "aud_put_hdr: resulting record size %d\n",
	    aud_size(rec_in));

	info_in.aud_info_type = AUD_TYPE_STRING;
	info_in.aud_info_p = "bsd.posix1e.posix_aud.test.aud_write";
	info_in.aud_info_length = strlen(info_in.aud_info_p) + 1;

	i = aud_put_hdr_info(hdr, AUD_LAST_ITEM, AUD_EVENT_TYPE,
	    &info_in);
	if (i == -1) {
		perror("aud_put_hdr_info");
		exit(-1);
	}

	fprintf(stdout, "aud_put_hdr_info: resulting record size %d\n",
	    aud_size(rec_in));

	status = AUD_SUCCESS;
	info_in.aud_info_type = AUD_TYPE_AUD_STATUS;
	info_in.aud_info_p = &status;
	info_in.aud_info_length = sizeof(aud_status_t);

	i = aud_put_hdr_info(hdr, AUD_LAST_ITEM, AUD_STATUS, &info_in);
	if (i == -1) {
		perror("aud_put_hdr_info");
		exit(-1);
	}

	fprintf(stdout, "aud_put_hdr_info: resulting record size %d\n",
	    aud_size(rec_in));

	info_in.aud_info_type = AUD_TYPE_STRING;
	info_in.aud_info_length = strlen(PATH_1) + 1;
	info_in.aud_info_p = PATH_1;

	i = aud_put_event_info(evinfo_in, AUD_LAST_ITEM, AUD_RD_FILE_ID,
	    &info_in);
	if (i == -1) {
		perror("aud_put_event_info");
		exit(-1);
	}

	fprintf(stdout, "aud_put_event_info: resulting record size %d\n",
	    aud_size(rec_in));

	i = aud_write(AUD_SYSTEM_LOG, rec_in);
	if (i == -1) {
		perror("aud_write");
		exit(-1);
	}
}
