/*-
 * Copyright (c) 1999 Robert N M Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$FreeBSD $
 */
/*
 * setfacl -- POSIX.1e utility to manipulate file and directory ACLs
 */

#include <sys/types.h>
#include <sys/acl.h>
#include <stdio.h>
#include <unistd.h>

void
usage(void)
{

	/* XXX is this right? */
	fprintf(stderr, "setfacl [-bdka] [-m entries] [-M file1] [-x entries] "
	    "[-x file2] [file ...]\n");
}

int
main(int argc, char *argv[])
{
	int	ch;

	/* XXX is this right? */
	while ((ch = getopt(argc, argv, "bdkam:M:x:")) != -1)
		switch(ch) {
		case 'b':
		case 'd':
		case 'k':
		case 'm':
		case 'M':
		case 'x':
		default:
			usage();
			return(-1);
		}
	argc -= optind;
	argv += optind;



	return(0);
}
