/*-
 * Copyright (c) 1999 Robert N. M. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id $
 */

#include <sys/types.h>
#include <sys/acl.h>
#include <stdio.h>

void
main(int argc, char *argv[])
{
	acl_t	acl;
	char	*buf=0;
	ssize_t	buf_len;

	acl = acl_init(3);

	acl->acl_entry[0].ae_tag = ACL_USER_OBJ;
	acl->acl_entry[0].ae_id = 0;
	acl->acl_entry[0].ae_perm = ACL_PERM_WRITE | ACL_PERM_READ;
	acl->acl_entry[1].ae_tag = ACL_GROUP_OBJ;
	acl->acl_entry[1].ae_id = 0;
	acl->acl_entry[1].ae_perm = ACL_PERM_WRITE | ACL_PERM_READ;
	acl->acl_entry[2].ae_tag = ACL_OTHER;
	acl->acl_entry[2].ae_id = 0;
	acl->acl_entry[2].ae_perm = ACL_PERM_READ;
	acl->acl_entry[3].ae_tag = ACL_USER;
	acl->acl_entry[3].ae_id = 2;
	acl->acl_entry[3].ae_perm = ACL_PERM_WRITE | ACL_PERM_READ;
	acl->acl_entry[4].ae_tag = ACL_MASK;
	acl->acl_entry[4].ae_id = 0;
	acl->acl_entry[4].ae_perm = ACL_PERM_READ;
	acl->acl_cnt = 5;

	buf = acl_to_text(acl, &buf_len);
	if (!buf) {
		perror("acl_to_text");
		exit(-1);
	}

	printf("%s\n", buf);
	acl_sort(acl);

	buf = acl_to_text(acl, &buf_len);
	if (!buf) {
		perror("acl_to_text");
		exit(-1);
	}

	printf(buf);

}
